﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Net.Sockets;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using Newtonsoft.Json;

namespace WindowsFormsApplication2
{
    public partial class Form1 : Form
    {
        private TcpClient client;
        private byte[] buffer = new byte[8 * 1024];
        private Encoding encoding = Encoding.UTF8;
        private Random rnd = new Random();

        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {

        }

        public void VeriGeldi(IAsyncResult ar)
        {
            int okunan = client.Client.EndReceive(ar);
            if (okunan > 0)
            {
                string mesaj = this.encoding.GetString(this.buffer, 0, okunan);
                VeriAyikla(mesaj);

            }
            client.Client.BeginReceive(buffer, 0, buffer.Length, SocketFlags.None, VeriGeldi, 0);
        }

        private void VeriAyikla(string mesaj)
        {
            Dictionary<string, string> olay = JsonConvert.DeserializeObject<Dictionary<string, string>>(mesaj);
            string aciklama = "\r\n== YENİ OLAY " + DateTime.Now.ToString() + " ==\r\n";
            foreach (var satir in olay)
            {
                aciklama += String.Format("{0}: {1}\r\n", satir.Key, satir.Value);
            }
            this.Invoke((MethodInvoker)delegate ()
            {
                mesajlarTB.AppendText(aciklama);
            });
        }

        private void Login()
        {
            Dictionary<string, string> komut = new Dictionary<string, string>();
            komut.Add("command", "login");
            komut.Add("crm_id", rnd.Next().ToString());
            komut.Add("username", kullTB.Text);
            komut.Add("password", SifreTB.Text);

            string paket = JsonConvert.SerializeObject(komut) + "\n\n";
            this.client.Client.Send(this.encoding.GetBytes(paket));
        }

        private void baglanBtn_Click(object sender, EventArgs e)
        {
            this.client = new TcpClient(hostTB.Text, Convert.ToInt32(portTB.Text));
            Login();
            client.Client.BeginReceive(buffer, 0, buffer.Length, SocketFlags.None, VeriGeldi, 0);
        }

        private void cagriBaslatBtn_Click(object sender, EventArgs e)
        {
            Dictionary<string, string> komut = new Dictionary<string, string>();
            komut.Add("command", "originate");
            komut.Add("customer_num", arananNoTB.Text);
            komut.Add("pbx_num", santralNoTB.Text);
            komut.Add("internal_num", arayanNoTB.Text);
            komut.Add("crm_id", rnd.Next().ToString());
            komut.Add("originate_order", "if");

            string paket = JsonConvert.SerializeObject(komut) + "\n\n";
            this.client.Client.Send(this.encoding.GetBytes(paket));
        }
    }
}
